################################################################################
#####Analysis of the pipeline accidents study in section 8 
################################################################################




############################################
#####Letter-value plots
############################################
LV=function(Data,x){
  TBE=data[[2]]
  cost=data[[8]]/1000000
  time=data[[1]]
  n=length(TBE)
  if(x=='TBE'){
   system=c(rep("A",n) )
  group=c(rep("1",n) )
  Respiratory_Rate=c(TBE)
  data_plot=data.frame(system,Respiratory_Rate,group)
 return( data_plot %>%
    ggplot(aes(x = system, y=Respiratory_Rate, fill=group)) + 
    geom_lv(color='black', size=0.75)  +
    geom_boxplot(outlier.alpha = 0, coef=0,lwd=1,fatten=2.5)+
    theme(legend.position = "None")+  
    xlab("") + 
    ylab("TBE") +
    ggtitle("") +
    theme(plot.title = element_text(hjust = 0.5)) +
    scale_fill_manual("",values=c("#E69F00","#0070CC"),labels=c('ES', 'CB'))+
    scale_x_discrete(labels = c(''))) }
  
  #####
if(x=='cost'){
  system=c(rep("A",n) )
  group=c(rep("1",n) )
  Respiratory_Rate=c(cost)
  data_plot=data.frame(system,Respiratory_Rate,group)
  return(data_plot %>%
    ggplot(aes(x = system, y=Respiratory_Rate, fill=group)) + 
    geom_lv(color='black', size=0.75)  +
    geom_boxplot(outlier.alpha = 0, coef=0,lwd=1,fatten=2.5)+
    theme(legend.position = "None")+  
    xlab(" ") + 
    ylab("Total cost") +
    ggtitle("") +
    theme(plot.title = element_text(hjust = 0.5)) +
    scale_fill_manual("",values=c("#0070CC","#0070CC"),labels=c('ES', 'CB'))+
    scale_x_discrete(labels = c(' '))) }
}

############################################
#####IFM Estimator for HPP
############################################

MLE_HPP=function(data,copula){
  # --define-TBE--and--amplitude
  X=data$X[1:2300]
  Y=data$Costs[1:2300]
  n=length(X)   # Number of accidents
  
  #### Time to event
  T[1]=X[1]
  for(i in 2:2300)
    T[i]=T[i-1]+X[i]
  #CDF of X
  F_x=function(x,gamma)
  1-exp(-gamma*x)
  #--MLE-HPP (exponential)--
  exp.lik<-function(y){
    gamma=y[1]
    logl=suppressWarnings(n*log(gamma)-gamma*sum(X))
    return(-logl)
  }
  OPT=optim(c(1),exp.lik,method = "Brent",lower=0,upper=10)
  gamma_hat=OPT$par[1]
  l_exp=exp.lik(gamma_hat)
  nHPP=1  #number of parameters
  AIC1=2*nHPP-2*l_exp
  #--cdf and Pdf of Y--
  f_y=function(y,mu)
    mu*exp(-mu*y)
  
  F_y=function(y,mu)
    1-exp(-mu*y)
  #--loglikelihood function(Y)--
  
  Y_lik=power.lik<-function(c){
    mu=c[1]
    ss=n*log(mu)-mu*sum(Y)
    return(-ss)
  }
  d=c(1.5)
  OPT2=optim(d,Y_lik, method ="Brent",lower=0.000001, upper=10)
  OPT2$par
  mu_hat= OPT2$par
  AIC2=2*1-2*Y_lik(mu_hat)
  
  
  if(copula=='frank')
  {
    lower=-100
    upper=100
    copula_lik<-function(c){
      theta_c=c[1]
      ss=0
      for(ii in 1:n)
      {
        if(dCopula(cbind(F_x(X[ii],gamma_hat),F_y(Y[ii],mu_hat)), copula = frankCopula(param =  theta_c))==0) l=1 else
        l=dCopula(cbind(F_x(X[ii],gamma_hat),F_y(Y[ii],mu_hat)), copula = frankCopula(param =  theta_c))
        ss=ss+log(l)
      }
      return(-ss)
    }}
  
  if(copula=='clayton')
  {
    lower=-1
    upper=100
    copula_lik<-function(c){
      theta_c=c[1]
      ss=0
      if(theta_c< -1 ) return(-Inf)
      if(theta_c==0) return(-Inf)
      for(ii in 1:(n))
      {
        if(dCopula(cbind(F_x(X[ii],gamma_hat),F_y(Y[ii],mu_hat)), copula = claytonCopula(param =  theta_c))==0) l=1 else
        l=dCopula(cbind(F_x(X[ii],gamma_hat),F_y(Y[ii],mu_hat)), copula = claytonCopula(param =  theta_c))
        ss=ss+log(l)
      }
      return(-ss)
    }}
  if(copula=='gumbel')
  {
    lower=1
    upper=100
    copula_lik<-function(c){
      theta_c=c[1]
      if(theta_c<1) return(-Inf)
      ss=0
      for(ii in 1:n)
      {
        if(dCopula(cbind(F_x(X[ii],gamma_hat),F_y(Y[ii],mu_hat)), copula = gumbelCopula(param =  theta_c))==0) l=1 else
       l=dCopula(cbind(F_x(X[ii],gamma_hat),F_y(Y[ii],mu_hat)), copula = gumbelCopula(param =  theta_c))
        ss=ss+log(l)
      }
      return(-ss)
    }}
  
  d=c(2)
  OPT3=optim(d,copula_lik,method = "Brent", lower=lower, upper=upper)
  theta_c_hat=OPT3$par
  if(copula=='clayton')
    tau_copula=tau(claytonCopula(dim=2,param = theta_c_hat))
  if(copula=='frank')
    tau_copula=tau(frankCopula(dim=2,param = theta_c_hat))
  if(copula=='gumbel')
    tau_copula=tau(gumbelCopula(dim=2,param = theta_c_hat))
  AIC3=2-2*copula_lik(theta_c_hat)
  return(list(gamma_hat,mu_hat,tau_copula,AIC1+AIC2+AIC3))
}
  
############################################
#####IFM Estimator for HPP with covariate 
############################################

MLE_HPPcov=function(data,copula){
  # --define-TBE--and--amplitude
  X=data$X[1:2300]
  
  Y=data$Costs[1:2300]
  # the covariates plus zero for intial values
  Z1 =c(0,as.numeric(data$Pipeline.Location)[1:2300])
  Z2= c(0,as.numeric(data$Pipeline.Type)[1:2300])
  Z3=c(0,as.numeric(data$Liquid.Type)[1:2300])
  Z4=c(0,as.numeric(data$Accident.State)[1:2300])
  Z5=c(0,as.numeric(data$Cause.Category)[1:2300])
  n=2300
  
  
  #### Time to event
  T[1]=X[1]
  for(i in 2:n)
    T[i]=T[i-1]+X[i]
  #Add zero for T0=0
  T=c(0,T)
  n=length(X)   # Number of accidents
  
  #--cdf of X--
  F_x=function(x,t,Z1,Z2,Z3,Z4,Z5,gamma,beta1,beta2,beta3,beta4,beta5)
    1-exp(-exp(beta1*Z1+beta2*Z2+beta3*Z3+beta4*Z4+beta5*Z5)*(gamma*(x+t)-gamma*(t)))
  #--loglikelihood function(X)--
  
  X_lik<-function(c){
    gamma=c[1]
    beta1=c[2]
    beta2=c[3]
    beta3=c[4]
    beta4=c[5]
    beta5=c[6]
    if(gamma==0) return(-Inf)
    if(gamma<0)  return(-Inf)
    s=0
    for(i in 2:2301)
    {
      s=s+gamma*(T[i]-T[i-1])*exp(beta1*Z1[i-1]+beta2*Z2[i-1]+beta3*Z3[i-1]+beta4*Z4[i-1]+beta5*Z5[i-1])
    }
    ss= n*log(gamma)+sum(beta1*Z1)+sum(beta2*Z2)+sum(beta3*Z3)+sum(beta4*Z4)+sum(beta5*Z5) -s
    return(-ss)
  }
  d=c(1,1,1,1,1,1)
  OPT1=optim(d,X_lik, method = "BFGS",control=list(maxit = 50000, temp = 20))
  OPT1$par



gamma_hat=OPT1$par[1]
beta1_hat=OPT1$par[2]
beta2_hat=OPT1$par[3]
beta3_hat=OPT1$par[4]
beta4_hat=OPT1$par[5]
beta5_hat=OPT1$par[6]

d=c(gamma_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat)
AIC1=2*7-2*X_lik(d)
#--cdf and Pdf of Y--
f_y=function(y,mu)
  mu*exp(-mu*y)

F_y=function(y,mu)
  1-exp(-mu*y)

#--loglikelihood function(Y)--

Y_lik=power.lik<-function(c){
  mu=c[1]
  ss=n*log(mu)-mu*sum(Y)
  return(-ss)
}
d=c(1.5)
Y_lik(d)
OPT2=optim(d,Y_lik, method ="Brent",lower=0.000001, upper=10)
OPT2$par
mu_hat= OPT2$par
AIC2=2-2*Y_lik(mu_hat)

if(copula=='frank')
{
  lower=-100
  upper=100
  copula_lik<-function(c){
    theta_c=c[1]
    ss=0
    for(ii in 2:(n))
    {
      if(dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = frankCopula(param =  theta_c))==0) l=1 else
        l=dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = frankCopula(param =  theta_c))
      ss=ss+log(l)
    }
    return(-ss)
  }}

if(copula=='clayton')
{
  lower=-1
  upper=100
  copula_lik<-function(c){
    theta_c=c[1]
    ss=0
    if(theta_c< -1 ) return(-Inf)
    if(theta_c==0) return(-Inf)
    for(ii in 2:(n))
    {
      if(dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = claytonCopula(param =  theta_c))==0) l=1 else
        l=dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = claytonCopula(param =  theta_c))
      ss=ss+log(l)
    }
    return(-ss)
  }}
if(copula=='gumbel')
{
  lower=1
  upper=100
  copula_lik<-function(c){
    theta_c=c[1]
    if(theta_c<1) return(-Inf)
    ss=0
    for(ii in 2:n)
    {
      if(dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = gumbelCopula(param =  theta_c))==0) l=1 else
        l=dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = gumbelCopula(param =  theta_c))
      ss=ss+log(l)
    }
    return(-ss)
  }}

d=c(2)
OPT3=optim(d,copula_lik,method = "Brent", lower=lower, upper=upper)
theta_c_hat=OPT3$par
if(copula=='clayton')
  tau_copula=tau(claytonCopula(dim=2,param = theta_c_hat))
if(copula=='frank')
  tau_copula=tau(frankCopula(dim=2,param = theta_c_hat))
if(copula=='gumbel')
  tau_copula=tau(gumbelCopula(dim=2,param = theta_c_hat))
AIC3=2-2*copula_lik(theta_c_hat)

return(list(gamma_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat,mu_hat,tau_copula,AIC1+AIC2+AIC3))
}

############################################
#####IFM Estimator for NHPP (power low)
############################################
IFM_power=function(data,copula){
  # --define-TBE--and--amplitude
  X=data$X[1:2300]
  
  Y=data$Costs[1:2300]
  # the covariates plus zero for intial values
  Z1 =c(0,as.numeric(data$Pipeline.Location)[1:2300])
  Z2= c(0,as.numeric(data$Pipeline.Type)[1:2300])
  Z3=c(0,as.numeric(data$Liquid.Type)[1:2300])
  Z4=c(0,as.numeric(data$Accident.State)[1:2300])
  Z5=c(0,as.numeric(data$Cause.Category)[1:2300])
  
  #### Time to event
  T[1]=X[1]
  for(i in 2:2300)
    T[i]=T[i-1]+X[i]
  #Add zero for T0=0
  T1=c(0,T)
  n=length(X)   # Number of accidents
    ##--cdf of X--
  F_x=function(x,t,z1,z2,z3,z4,z5,gamma,eta,beta1,beta2,beta3,beta4,beta5)
    1-exp(-gamma*((x+t)^eta-t^eta)*exp(z1*beta1+z2*beta2+z3*beta3+z4*beta4+z5*beta5))
  
  #--loglikelihood function(X)--
  
  
  X_lik<-function(c){
    gamma=c[1]
    eta=c[2]
    beta1=c[3]
    beta2=c[4]
    beta3=c[5]
    beta4=c[6]
    beta5=c[7]
    if(gamma<0) return(-Inf) # in power law intensity gamma>0
    if(eta<0) return(-Inf)  # in power law intensity eta>0
    s=0
    for(i in 2:(n+1))
    {
      s=s+gamma*exp(beta1*Z1[i]+beta2*Z2[i]+beta3*Z3[i]+beta4*Z4[i]+beta5*Z5[i])*(T1[i]^eta -T1[i-1]^eta ) 
    }
    ss= n*log(gamma)+n*log(eta)+(eta-1)*sum(log(T))+sum(beta1*Z1+beta2*Z2+beta3*Z3+beta4*Z4+beta5*Z5) -s
    return(-ss)
  }
 # d=c(2,1,1,1,1,1,1)
  d=c(3,3,3,3,3,3,3)
 
  OPT1=optim(d,X_lik, method="BFGS",control = list(maxit=50000))
  OPT1$par
  gamma_hat=OPT1$par[1]
  eta_hat=OPT1$par[2]
  beta1_hat=OPT1$par[3]
  beta2_hat=OPT1$par[4]
  beta3_hat=OPT1$par[5]
  beta4_hat=OPT1$par[6]
  beta5_hat=OPT1$par[7]
  
  d=c(gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat)
  AIC1=2*7-2*X_lik(d)
  #--cdf and Pdf of Y--
  f_y=function(y,mu)
    mu*exp(-mu*y)
  
  F_y=function(y,mu)
    1-exp(-mu*y)
  #--loglikelihood function(Y)--
  
  Y_lik=power.lik<-function(c){
    mu=c[1]
    ss=n*log(mu)-mu*sum(Y)
    return(-ss)
  }
  d=c(1.5)
  OPT2=optim(d,Y_lik, method ="Brent",lower=0.000001, upper=10)
  OPT2$par
  mu_hat= OPT2$par
  AIC2=2*1-2*Y_lik(mu_hat)
  
  if(copula=='frank')
  {
    lower=-100
    upper=100
    copula_lik<-function(c){
      theta_c=c[1]
      ss=0
      for(ii in 2:(n))
      {
        if(dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = frankCopula(param =  theta_c))==0) l=1 else
          l=dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = frankCopula(param =  theta_c))
        ss=ss+log(l)
      }
      return(-ss)
    }}
  
  if(copula=='clayton')
  {
    lower=-1
    upper=100
      copula_lik<-function(c){
      theta_c=c[1]
      ss=0
      if(theta_c< -1 ) return(-Inf)
      if(theta_c==0) return(-Inf)
      for(ii in 2:(n))
      {
        if(dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = claytonCopula(param =  theta_c))==0) l=1 else
          l=dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = claytonCopula(param =  theta_c))
        ss=ss+log(l)
      }
      return(-ss)
      }}
  if(copula=='gumbel')
  {
    lower=1
    upper=100
    copula_lik<-function(c){
    theta_c=c[1]
    if(theta_c<1) return(-Inf)
    ss=0
    for(ii in 2:n)
    {
      if(dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = gumbelCopula(param =  theta_c))==0) l=1 else
        l=dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = gumbelCopula(param =  theta_c))
      ss=ss+log(l)
    }
    return(-ss)
  }}
  
  d=c(2)
  OPT3=optim(d,copula_lik,method = "Brent", lower=lower, upper=upper)
  theta_c_hat=OPT3$par
  if(copula=='clayton')
  tau_copula=tau(claytonCopula(dim=2,param = theta_c_hat))
  if(copula=='frank')
    tau_copula=tau(frankCopula(dim=2,param = theta_c_hat))
  if(copula=='gumbel')
    tau_copula=tau(gumbelCopula(dim=2,param = theta_c_hat))
  AIC3=2-2*copula_lik(theta_c_hat)

  return(list(gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat,mu_hat,tau_copula,AIC1+AIC2+AIC3))
}


############################################
#####IFM Estimator for NHPP (log linear)
############################################
IFM_Log=function(data,copula){
  
  # --define-TBE--and--amplitude
  X=data$X[1:2300]
  
  Y=data$Costs[1:2300]
  # the covariates plus zero for intial values
  Z1 =c(0,as.numeric(data$Pipeline.Location)[1:2300])
  Z2= c(0,as.numeric(data$Pipeline.Type)[1:2300])
  Z3=c(0,as.numeric(data$Liquid.Type)[1:2300])
  Z4=c(0,as.numeric(data$Accident.State)[1:2300])
  Z5=c(0,as.numeric(data$Cause.Category)[1:2300])
  n=length(X)
  
  #### Time to event
  T[1]=X[1]
  for(i in 2:n)
    T[i]=T[i-1]+X[i]
  #Add zero for T0=0
  T1=c(0,T)
  n=length(X)   # Number of accidents
  
  #--cdf of X--
  F_x=function(x,t,z1,z2,z3,z4,z5,gamma,eta,beta1,beta2,beta3,beta4,beta5)
    1-exp(-gamma*((x+t)^eta-t^eta)*exp(z1*beta1+z2*beta2+z3*beta3+z4*beta4+z5*beta5))
  #--loglikelihood function(X)--
  
  X_lik<-function(c){
    gamma=c[1]
    eta=c[2]
    beta1=c[3]
    beta2=c[4]
    beta3=c[5]
    beta4=c[6]
    beta5=c[7]
    if(eta==0) return(-Inf)
    s=0
    for(i in 2:(n+1))
    {
      s=s+(exp(gamma+eta*T1[i])-exp(gamma+eta*T1[i-1]))*exp(beta1*Z1[i]+beta2*Z2[i]+beta3*Z3[i]+beta4*Z4[i]+beta5*Z5[i])
    }
    ss= n*gamma+eta*sum(T1)+sum(beta1*Z1+beta2*Z2+beta3*Z3+beta4*Z4+beta5*Z5)-(1/eta)*s
  }
  d=c(-4,-2,1,1,1,1,1)
  X_lik(d)
  OPT1=optim(d,X_lik,method="BFGS",control = list(maxit=50000))
  OPT1$par
  gamma_hat=OPT1$par[1]
  eta_hat=OPT1$par[2]
  beta1_hat=OPT1$par[3]
  beta2_hat=OPT1$par[4]
  beta3_hat=OPT1$par[5]
  beta4_hat=OPT1$par[6]
  beta5_hat=OPT1$par[7]
  
  d=c(gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat)
  AIC1=2*7-2*X_lik(d)
  
  #--cdf and Pdf of Y--
  f_y=function(y,mu)
    mu*exp(-mu*y)
  
  F_y=function(y,mu)
    1-exp(-mu*y)
  #--loglikelihood function(Y)--
  
  Y_lik=power.lik<-function(c){
    mu=c[1]
    ss=n*log(mu)-mu*sum(Y)
    return(-ss)
  }
  d=c(2.6)
  OPT2=optim(d,Y_lik, method ="Brent",lower=0.000001, upper=10)
  OPT2$par
  mu_hat= OPT2$par
  AIC2=2*1-2*Y_lik(mu_hat)
  
  if(copula=='frank')
  {
    lower=-100
    upper=100
    copula_lik<-function(c){
      theta_c=c[1]
      ss=0
      for(ii in 2:n)
      {
        if(dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = frankCopula(param =  theta_c))==0) l=1 else
          l=dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = frankCopula(param =  theta_c))
        ss=ss+log(l)
      }
      return(-ss)
    }}
  
  if(copula=='clayton')
  {
    lower=-1
    upper=100
    copula_lik<-function(c){
      theta_c=c[1]
      ss=0
      if(theta_c< -1 ) return(-Inf)
      if(theta_c==0) return(-Inf)
      for(ii in 2:n)
      {
        if(dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = claytonCopula(param =  theta_c))==0) l=1 else
          l=dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = claytonCopula(param =  theta_c))
        ss=ss+log(l)
      }
      return(-ss)
    }}

if(copula=='gumbel')
{
  lower=1
  upper=100
  copula_lik<-function(c){
  theta_c=c[1]
  if(theta_c<1) return(-Inf)
  ss=0
  for(ii in 2:n)
  {
    if(dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = gumbelCopula(param =  theta_c))==0) l=1 else
      l=dCopula(cbind(F_x(X[ii],T[ii],Z1[ii],Z2[ii],Z3[ii],Z4[ii],Z5[ii],gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat),F_y(Y[ii],mu_hat)), copula = gumbelCopula(param =  theta_c))
    ss=ss+log(l)
  }
  return(-ss)
}}

  d=c(2)
  OPT3=optim(d,copula_lik,method = "Brent", lower=lower, upper=upper)
  theta_c_hat=OPT3$par
  if(copula=='clayton')
    tau_copula=tau(claytonCopula(dim=2,param = theta_c_hat))
  if(copula=='frank')
    tau_copula=tau(frankCopula(dim=2,param = theta_c_hat))
  if(copula=='gumbel')
    tau_copula=tau(gumbelCopula(dim=2,param = theta_c_hat))
  
  AIC3=2-2*copula_lik(theta_c_hat)

  return(list(gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat,mu_hat,tau_copula,AIC1+AIC2+AIC3))
}


###################################
##########Phase I
###################################
PhaseI=function(data,d)
{
  X=data$X[1:2781]
  Y=data$Costs[1:2781]
  W=Y/X
  if(d=="W"){
  plot(W,type="o",xlab=expression(italic(i)),ylab=expression(italic(W[i])))
    abline(v=2300, col="red", lty=2, lwd=2)
    text(800,max(W),'Phase I', col="blue",cex=.6)
   text(2500,max(W),'Phase II', col="blue",cex=.6)
    #mtext("              Phase I                                           Phase II", col="blue",cex = .6)
    }
  if(d=="logW"){
    plot(log(W),type="o",xlab=expression(italic(i)),ylab=expression(italic(log(W[i]))))
    abline(v=2300, col="red", lty=2, lwd=2)
    text(800,max(log(W)),'Phase I', col="blue",cex=.6)
    text(2500,max(log(W)),'Phase II', col="blue",cex=.6)
    }
  if(d=="Y"){
  plot(Y,type="o",xlab=expression(italic(i)),ylab=expression(italic(Y[i])))
    abline(v=2300, col="red", lty=2, lwd=2)
    text(800,max(Y),'Phase I', col="blue",cex=.6)
    text(2500,max(Y),'Phase II', col="blue",cex=.6)
    }
  if(d=="X"){
  plot(X,type="o",xlab=expression(italic(i)),ylab=expression(italic(X[i])))
    abline(v=2300, col="red", lty=2, lwd=2)
    text(800,max(X),'Phase I', col="blue",cex=.6)
    text(2500,max(X),'Phase II', col="blue",cex=.6)
  }
}

###################################
##########Phase II
###################################
PhaseII=function(data,d)
{
  
  # --define-TBE--and--amplitude
  X=data$X
  
  Y=data$Costs
  # the--covariates--plus--zero--for--intial--values
  Z1 =c(0,as.numeric(data$Pipeline.Location))
  Z2= c(0,as.numeric(data$Pipeline.Type))
  Z3=c(0,as.numeric(data$Liquid.Type))
  Z4=c(0,as.numeric(data$Accident.State))
  Z5=c(0,as.numeric(data$Cause.Category))
  #### Time to event
  T[1]=X[1]
  for(i in 2:2781)
    T[i]=T[i-1]+X[i]
  
  #Add zero for T0=0
  T1=c(0,T)
  #Estimated parameters based on Phase I
  gamma=0.024
  eta=1.071
  beta1=-0.156
  beta2=-0.010
  beta3=0.008
  beta4=0.001
  beta5=0.022
  mu=3.36e-06
  theta_c=iTau(gumbelCopula(),tau = 0.002)
  copula=gumbelCopula(param=theta_c,dim=2)
  alpha=0.005  #ARL0=200
  
  UCL=c(0)
  LCL=c(0)
  w=c(0)
  kk=1
  for(i in 2681:2781)
  {
    z1=Z1[i]
    z2=Z2[i]
    z3=Z3[i]
    z4=Z4[i]
    z5=Z5[i]
    t=T1[i-1]
    t
    #--cdf of X--
    F_x=function(x)
      1-exp(-gamma*((x+t)^eta-t^eta)*exp(z1*beta1+z2*beta2+z3*beta3+z4*beta4+z5*beta5))
    
    
    #--pdf of X--
    f_x=function(x)
      gamma*eta*(x+t)^(eta-1)*exp(z1*beta1+z2*beta2+z3*beta3+z4*beta4+z5*beta5)* exp(-gamma*((x+t)^eta-t^eta)*exp(z1*beta1+z2*beta2+z3*beta3+z4*beta4+z5*beta5))
    
    
    
    #--cdf of Y--
    F_y=function(y)
      1-exp(-mu*y)
    #--pdf of Y--
    f_y=function(y)
      mu*exp(-mu*y)
    ## Define the function C(u, v)
    Pgumbel <- function(u, v) {
      exp(-(((-log(u))^theta_c + (-log(v))^theta_c)^(1/theta_c)))
    }
    #Define the function c(u, v)
    dgumbel=function(u,v)
    {
      Pgumbel(u, v)/(u*v)*(((-log(u))^theta_c+(-log(v))^theta_c)^((2/theta_c)-2))/((log(u)*log(v))^(1-theta_c))*(1+(theta_c-1)*((-log(u))^theta_c+(-log(v))^theta_c)^(-1/theta_c))
    }
    #fxy=c(F_x(x),F_y(y))*f_x(x)*f_y(y)
    fxy=function(x,y){
      dgumbel(F_x(x),F_y(y))*f_x(x)*f_y(y)
      
    }
 
    ### to calculate UCL
    equation1=function(w)
    {
      target_value <- 1-alpha/2
      ff = function(x) {
        integrate(function(y) {fxy(x,y)},0, x*w)$value
      }
      
      integral_value=integrate(Vectorize(ff), 0,95)$value
      integral_value-target_value
    }
    
    #UCL[kk]=uniroot(equation1, interval = c(0.00001, 1e08),extendInt = "yes")$root
    
    xstart=1
    z <- nleqslv(xstart, equation1, jacobian=TRUE,control=list(btol=.001))
    UCL[kk]=z$x
    log(UCL[kk])
    
    
    
    
    
    # to calculate LCL
    equation2=function(w)
    {
      target_value <- alpha/2
      ff = function(x) {
        integrate(function(y) {fxy(x,y)},0, x*w)$value
      }
      
      integral_value=integrate(Vectorize(ff), 0,10000)$value
      integral_value-target_value
    }
    
    #LCL[kk]=uniroot(equation2, interval = c(0.00001, 102),extendInt = "yes")$root
    
    xstart=10
    z <- nleqslv(xstart, equation2, jacobian=TRUE,control=list(btol=.01))
    LCL[kk]=z$x
    LCL[kk]
    w[kk]=Y[i]/X[i]
    
    kk=kk+1
    
  }
  
  #plot control chart with orignal control limits
  
  l=1
  u=100
  if(d=="Org"){
  ww=w[l:u]
  UCLw=UCL[l:u]
  LCLw=LCL[l:u]
  plot(ww,type="o", lwd = 1, xlab=expression(italic(i)),ylab=expression(italic(w[i])),ylim=c(0,max(UCLw)))
  lines(LCLw,col="green", type = "l")
  points(UCLw,col="blue", type = "l", pch=20)
  for(ii in 1:u)
  {
    if(ww[ii]>UCLw[ii])
      points( ii,ww[ii],col="red", type = "o")
  }
  
  for(v in 1:u)
  {
    if(ww[v]<LCLw[v])
      points( v,ww[v],col="red", type = "o")
  }
  legend(70,1e07, legend = expression(paste( italic(UCL) ), paste( italic(LCL) )),
         col =c("blue","green"), text.col = c("blue","green"), lty = 1, lwd = 3,
         merge = TRUE, bg = "gray95",cex=0.6,text.width = 4
  )
}
  
  #plot control chart with log 0f control limits

  if(d=="Log"){
  ww=log(w[l:u])
  UCLw=log(UCL[l:u])
  LCLw=log(LCL[l:u])
  plot(ww,type="o", lwd = 1, xlab=expression(italic(i)),ylab=expression(italic(log(W[i]))),ylim=c(0,max(UCLw)))
  lines(LCLw,col="green", type = "l")
  points(UCLw,col="blue", type = "l", pch=20)
  
  
  for(ii in 1:u)
  {
    if(ww[ii]>UCLw[ii])
      points( ii,ww[ii],col="red", type = "o")
  }
  
  for(v in 1:u)
  {
    if(ww[v]<LCLw[v])
      points( v,ww[v],col="red", type = "o")
  }
  
  
  legend(70,max(UCLw-1), legend = expression(paste( italic(log(UCL)) ), paste( italic(log(LCL)))),
         col =c("blue","green"), text.col = c("blue","green"), lty = 1, lwd = 3,
         merge = TRUE, bg = "gray95",cex=0.6,text.width = 8
  )
  }
}

####################################
#####Cox Proportional Hazards Analysis
####################################
cox=function(data)
{

  # --read-TBE--
  X=data$X[1:2300]
  n=2300
  #### Time to event
  T[1]=X[1]
  for(i in 2:n)
    T[i]=T[i-1]+X[i]
  # Define the covariates 
  Z1 =as.numeric(data$Pipeline.Location)[1:2300]
  Z2= as.numeric(data$Pipeline.Type)[1:2300]
  Z3=as.numeric(data$Liquid.Type)[1:2300]
  Z4=as.numeric(data$Accident.State)[1:2300]
  Z5=as.numeric(data$Cause.Category)[1:2300]
  
  status=matrix(1,ncol=1,nrow = 2300)
  
  # apply the univariate coxph function to multiple covariates at once
  covariates <- c("Z1", "Z2" ,"Z3","Z4","Z5")
  
  univ_formulas <- sapply(covariates,
                          function(x) as.formula(paste('Surv(T,status)~', x)))
  
  univ_models <- lapply( univ_formulas, function(x){coxph(x, data = data)})
  # Extract data 
  univ_results <- lapply(univ_models,
                         function(x){ 
                           x <- summary(x)
                           p.value<-signif(x$wald["pvalue"], digits=2)
                           wald.test<-signif(x$wald["test"], digits=2)
                           beta<-signif(x$coef[1], digits=2);#coeficient beta
                           HR <-signif(x$coef[2], digits=2);#exp(beta)
                           HR.confint.lower <- signif(x$conf.int[,"lower .95"], 2)
                           HR.confint.upper <- signif(x$conf.int[,"upper .95"],2)
                           HR <- paste0(HR, " (", 
                                        HR.confint.lower, "-", HR.confint.upper, ")")
                           res<-c(beta, HR, wald.test, p.value)
                           names(res)<-c("beta", "HR (95% CI for HR)", "wald.test", 
                                         "p.value")
                           return(res)
                           #return(exp(cbind(coef(x),confint(x))))
                         })
  res <- t(as.data.frame(univ_results, check.names = FALSE))
  return(as.data.frame(res))
  
  
  
  
}

#################################
#####Exponential test for TBE
#################################
EXP.test=function(data,d)
{
  if(d=="TBE")   var=data$X[1:2300]
  if(d=="Costs") var=data$Costs[1:2300]
  
 ex= fitdist(var, "exp", method = "mme")
 
 plot(ex) 

 # KS-test for Exponential distribution
 
d=ks.test(var, pexp(ex$estimate[[1]]))
return(c(ex$estimate[[1]], d$p.value) ) 
}

#################################
##### ARL based Power law intensity
#################################
ARL_power=function(gamma0, eta0, beta,mu0,tau,delta_gamma,delta_eta,delta_mu)
{
  # Set out-of-control parameters of power law  and covariate
  gamma1 =gamma0*delta_gamma
  eta1 = eta0*delta_eta
  mu1=mu0*delta_eta
  # Set the amplitude parameter "mu"
  
  alpha = 0.005 # To Get ARL0=200
  N = 10000  #number of samples to find UCL
  ##set the copula and its parameter 
  
  theta_c=iTau(gumbelCopula(dim=2),tau=tau)
  copula=gumbelCopula(param=theta_c,dim=2)
  
  # Number of simulations
  num_simulations = 5000
  
  # Initialize the vector to store ARL values
  RL = c(0)
  # Set the set of possible outcomes and truncated range for covariate
  outcomes <- c(1, 2,3)
  probs <- dpois(outcomes, 1)
  
  
  # Perform simulations
  for (i in 1:num_simulations) {
    XU = numeric(N)
    YU = numeric(N)
    WU = numeric(N)
    rL = 0  # For Run Length
    W = 1
    UCL = 2
    LCL=0
    t = c(0)
    t[1] = 0  # Time to start (t = 0)
    z=c(0)
    z[1] = 0  # Covariate for initial time to event
    k=2
    # Simulate until W exceeds UCL
    while (W < UCL&W>LCL) {
      G=rCopula(copula=copula,N)
      
      
      z[k]=sample(outcomes, size = 1, replace = TRUE, prob = probs)
      
      # Generate N sample of TBE (power law)
      XU =  (-log(1-G[,1])/(gamma0*exp(beta*z[k]))+t[k-1]^eta0)^(1/eta0)- t[k-1]
      # Generate N sample of Amplitude
      YU = -log(1-G[,2])/mu0
      # Calculate Total cost to define the UCL
      WU = YU / XU
      UCL = quantile(WU, 1 - alpha/2)[[1]]
      LCL= quantile(WU, alpha/2)[[1]]
      # Generate TBE for next failure
      GG=rCopula(copula=copula,1)
      TBE =  (-log(1-GG[,1])/(gamma1*exp(beta*z[k]))+t[k-1]^eta1)^(1/eta1)- t[k-1]
      # Generate Amplitude for next failure
      Y =  -log(1-GG[,2])/mu1
      # Calculate cost for next failure
      W = Y / TBE
      t[k] = t[k-1] + TBE  # Time to next failure
      rL = rL + 1
      k=k+1
    }
    RL[i] = rL
     }
  
  return(mean(RL))
  
}

#################################
##### ARL based log linear intensity
#################################
ARL_log=function(gamma0, eta0, beta,mu0,tau,delta_gamma,delta_eta,delta_mu)
{
  # Set out-of-control parameters of power law  and covariate
  gamma1 =gamma0*delta_gamma
  eta1 = eta0*delta_eta
  mu1=mu0*delta_mu
  # Set the amplitude parameter "mu"
  
  alpha = 0.005 # To Get ARL0=200
  N = 10000  #number of samples to find UCL
  ##set the copula and its parameter 

  theta_c=iTau(gumbelCopula(dim=2),tau=tau)
  copula=gumbelCopula(param=theta_c,dim=2)
  
  # Number of simulations
  num_simulations = 5000
  
  # Initialize the vector to store ARL values
  RL = c(0)
  # Set the set of possible outcomes and truncated range for covariate
  outcomes <- c(1, 2,3)
  probs <- dpois(outcomes, 1)
  
  
  # Perform simulations
  for (i in 1:num_simulations) {
    XU = numeric(N)
    YU = numeric(N)
    WU = numeric(N)
    rL = 0  # For Run Length
    W = 1
    UCL = 2
    LCL=0
    t = c(0)
    t[1] = 0  # Time to start (t = 0)
    z=c(0)
    z[1] = 0  # Covariate for initial time to event
    k=2
    # Simulate until W exceeds UCL
    while (W < UCL&W>LCL) {
      G=rCopula(copula=copula,N)
      
      
      z[k]=sample(outcomes, size = 1, replace = TRUE, prob = probs)
      
      # Generate N sample of TBE (power law)
      XU =  log(abs( (-eta0*log(1-G[,2]))/(exp(gamma0)*exp(beta*z[k]))+exp(eta0*t[k-1])))/(eta0)-t[k-1]
      # Generate N sample of Amplitude
      YU = -log(1-G[,2])/mu0
      # Calculate Total cost to define the UCL
      WU = YU / XU
      UCL = quantile(WU, 1 - alpha/2)[[1]]
      LCL= quantile(WU, alpha/2)[[1]]
      # Generate TBE for next failure
      GG=rCopula(copula=copula,1)
      TBE =  log(abs( (-eta1*log(1-GG[,2]))/(exp(gamma1)*exp(beta*z[k]))+exp(eta1*t[k-1])))/(eta1)-t[k-1]
      # Generate Amplitude for next failure
      Y =  -log(1-GG[,2])/mu1
      # Calculate cost for next failure
      W = Y / TBE
      t[k] = t[k-1] + TBE  # Time to next failure
      rL = rL + 1
      k=k+1
    }
    RL[i] = rL
     }
  
  return(mean(RL))
}